	[G, Z, P] = CA_POLES_Z2(Wc, Ws, Amax, Amin, N)
	
	% Computes the poles and zeros for a digital lowpass Cauer filter of type a.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-08
	% 	Modified by: 	LW
	% 	Version: 		1
	% 	Known bugs:
	% 	Copyright:		by authors - not released for commercial use	
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	% This file has been constructed based the lecure notes 
	% http://www.cs.tut.fi/~ts/part4.pdf as well as the article
	% S. Darlington, "Simple algorithms for elliptic filters and 
	% generalizations thereof", IEEE Trans. Circuits and Systems, CAS-25, 
	% pp. 975 - 980, Dec. 1978.
	% Tapio Saramki 20.11.1997; this program can be found in 
	% SUN's: ~ts/matlab/dsp/aellip.m
	
	aconstant = tan(wcT/2);	
	%--------------------
	% A(i+1) == a_i
	%---------------------
	A(1) = sqrt(tan(wcT/2)/tan(wsT/2));
	for i = 1:4
		A(i+1) = A(i)^2+sqrt(A(i)^4-1);
	end
	%------------------
	% J(i+1) == J_i
	%--------------------
	J(5) = 2^(N-1)*A(5)^N;
	for i = 1:4
		J(5-i) = (J(5-i+1)+1/J(5-i+1))/2;
		J(5-i) = sqrt(J(5-i));
	end
	K = sqrt(10^(Amax/10)-1);
	% sqrt(1/(10^(Amax/10)-1))+sqrt(1/(1/(10^(Amax/10)-1)+1)
	%---------------
	% SS(I+1) == S_I0
	%---------------
	SS(2) = 1/K+sqrt(1/(K*K)+1);
	for i = 3:4
		SS(i) = J(i-1)*SS(i-1);
		if SS(i) <= 10^150 
			SS(i) = SS(i)+sqrt(SS(i)*SS(i)+1);
		else
			SS(i) = 2*SS(i);
		end
	end
	%----------------------------------------
	% To prevent overflows, calculate S_40/J3, instead of S_40, that is,
	% S_40 == S_40/J3 = S_30+sqrt(S_30*S_30-1/(J3*J3))
	% In S_40 = J3*S_30+sqrt((J3*S_30)^2+1), (J3*S_30)^2 may cause an overflow.
	% Therefore S_40/J3 = S_30+sqrt((S_30)^2+1/(J3^2) is evaluated
	%----------------------------------------
	SS(5) = SS(4)+sqrt(SS(4)*SS(4)+1/(J(4)*J(4)));
	%---------------------
	% Calculate S50 == s_50:
	% Instead of J4/S_4, J4/(S_40*J3) is used for compensation
	%---------------------
	S50 = J(5)/(SS(5)*J(4));
	if S50 <= 10^150
		S50 = S50+sqrt(S50*S50+1);
	else
		S50 = 2*S50;
	end
	S50 = S50^(1/N);
	%------------------------------------------
	% Poles of the filter
	%------------------------------------------
	k = 1:N;
	pol = S50*exp(j*pi*(.5+(2*k-1)/(2*N)));
	for i = 1:5
		pol = (pol-ones(size(pol))./pol)/(2*A(6-i));
	end
	im = imag(pol);
	re = real(pol);
	% Why -re?? Some misuderstandings of the article. Anyway, the correct 
	% results are obtained as follows:
	pol = A(1)*(-re+j*im);
	P = (1+aconstant*pol)./(1-aconstant*pol);
	%--------------------------------------------
	% Zeros of the filter
	%--------------------------------------------
	kk = 1:floor(N/2);
	zer = A(5)*ones(size(kk))./(cos(pi*(2*kk-1)/(2*N)));
	for i = 1:4
		zer = (zer+ones(size(zer))./zer)/(2*A(5-i));
	end
	zer = A(1)*zer;
	zer = 2*atan(zer*aconstant);
	zero_angles(2*kk-1) = -zer(kk);
	zero_angles(2*kk) = zer(kk);
	if rem(N,2) == 1
		zero_angles(N) = pi;
	end
	Z = exp(j*zero_angles);	
	%----------------------------------------------
	% The scaling constant
	%--------------------------------------------
	% epsilon2 = 10^(Amax/10)-1;
	G = real(prod(1-P))/real(prod(1-Z));
	if rem(N,2) == 0 
		G = G*sqrt(10^(-Amax/10));
	end
	
